#ifndef LZ_GLOBALTRANSFORMS_GLSL
#define LZ_GLOBALTRANSFORMS_GLSL
/*
globalTransforms.glsl
Uniform block with standard, shader-wide data.
*/
//Definition for the standard uniform block with global parameters
layout(std140, binding = 0) uniform transforms {
	mat4 projection;//Projection matrix (camera projection)
	mat4 view;		//View matrix (camera transform)
	mat4 model;		//Model matrix (object transform)
	
	mat4 pv;		//Projection * View
	mat4 pvm;		//Projection * View * Model
	mat4 vm;		//View * Model

	vec4 camPos;	//Camera position
	vec4 mirrorPlane;//Mirroring plane used as a user defined clip plane
	uvec4 viewport; //The viewport used for this rendering operation (x,y,width,height)
	float zNearPlane;//The near plane
	float zFarPlane; //The far plane

	uint frameNumber;//Current integer frame number
	float frameTime; //Previous frame duration
	float time;		 //Current global time, in seconds
};
#endif